	function [L, C, Rs, RL, W0, K] = CA_LADDER(G,Z,R_ZEROS,P,Wc,Ws,Amax,Amin,Rs,RL,Ladder,Type)
	 
	% 	Computes the element values in a lowpass Cauer LC ladder filter with finite zeros
	%	of type a, b or c. Uses the transmission zeros and inputimpedance (ZinNum/ZinDen) 
	%	of the ladder for the synthesis. 
	%
	%	The element values can be improved by polishing, see below. Deactivated by default.
	%
	%	Ladder = 1 for a T ladder and 0 for a  ladder.
	%	Rs = source resistor and RL = load resistor.

	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author:			Lars Wanhammar, 2007-09-01
	% 	Modified by:	LW 2009-03-17, 2014-04-19, 2014-11-12
	%	Copyright:		by authors - not released for commercial use
	% 	Version:		1
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	[ZinNum, ZinDen] = ZIN_LADDER(Z, R_ZEROS, P); %	Compute Zin with Rs = 1
	Rs0 = Rs; RL0 = RL;
	% Compute normalizd load resistor
	RL = round(10^6*ZinNum(length(ZinNum))/ZinDen(length(ZinDen)))/10^6;
	Rs = 1;
 
	Type = lower(Type);
	[L, C, W0, K, winv] = LP_LADDER(ZinNum, ZinDen, Rs, RL, G, Z, P, Wc, Ws, Amax, Amin, Type);

	% ======================================================
	% 	Polishing of the element values
	%	The remaining lines may be activated if needed, by seting
	%	Polish = 1 in line 37. The element values are sligtly more accurate.
	%	This part is not activated since it is not needed in most cases.
	
	Polish = 0;
	if Polish == 1
		const = (RL+Rs)/RL;
		Norder = length(P);
		[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wc, Ws, Amax, Amin, Norder);
		if mod(Norder, 2) == 0 % even	
			if Type == 'a'
				const = 10^(-Amax/20)*const;
			end
			if Type == 'b'
				const = 10^(-Amax/20)*const;
				[G, Z, R_ZEROS, P, Wsnew] = CA_B_POLES_S(G, Z, P, 1, Wsnew, Amax, Amin);
			end
			if Type == 'c'	
				[G, Z, R_ZEROS, P, Wsnew] = CA_C_POLES_S(G, Z, P, 1, Wsnew, Amax, Amin);
			end
		end
		omegaP = sin([0:0.005:1]*pi/2); 
		Attideal = PZ_2_ATT_S(G, Z, P, omegaP);	
		% 	The improvment in the element values is limited by the accuracy of the 
		%	attenuation in the passband. Note that different algorithms for computing 
		%	the poles and zeros yield SLIGHTLY different results.
		
		[L, C, W0, K] = POLISH_LC(Attideal, omegaP, Norder, winv, L, C, K, Rs, RL, const);
	end

	% Synthesize a  ladder if needed
	if Ladder == 0
		[L, C, Rs, RL, K] = T_LADDER_2_PI(L, C, Rs, RL, K);
	end	
	for n = 1:2:length(W0)
		if Ladder == 1
			W0(n) = inf;
		else
			W0(n) = 0;
		end
	end
 
	L = Rs0*L;
	C = C/Rs0;
	RL = RL*Rs0;
	Rs = Rs0;
